/**
 *
 * \file        Hid.hpp
 *
 * \brief       Declaration for Functions for transmitting HID data over IP
 *
 * \author      AKN
 *
 * \date        10/26/2008
 *
 */
#ifndef _DM_HID_H_
#define _DM_HID_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef UINT32 SOCKET;
#pragma pack(1)

typedef struct
{
    unsigned char PacketType;
    unsigned char TransNumber;
    unsigned short Flags;
    unsigned short DataLength;
} HID_HEADER_INFO, *pHID_HEADER_INFO;

typedef struct
{
    HID_HEADER_INFO Header;
    unsigned char   Data[8];
} *pHID_PACKET, HID_PACKET;

typedef struct
{
    unsigned long   destIPAddress;      // IP address to connect/send data to
    unsigned short  destPort;           // port number to connect/send data to
    unsigned char   connectionType;     // 0 = TCP, 1 = UDP
    unsigned char   dataTypesDesired;   // Bit mask: Bit 0 = Mouse, Bit 1 = Keyboard, Bit 2 = Touch Screen
} HID_SWITCH_COMMAND, *pHID_SWITCH_COMMAND;

// Parameters for a TCP connection. Derived from TPS6X code
typedef struct
{
    int             gwSocket;
    unsigned char   gwIPaddress[4];
    unsigned short  gwPort;
    unsigned short  gwStatus;
    int             gwErrState;
    int             gwServIpErrCnt;
    int             connErrCnt;
    int             connCnt;
    unsigned long   closeReason;
} HID_TCP_PARAM_St, *pHID_TCP_PARAM_St;

#pragma pack()

extern SOCKET CIP_socketd;
extern SOCKET g_HIDsocket;
extern UINT32 g_CurrentTCPServer;

extern UINT8 g_MouseButtonState;
extern UINT8 g_HIDTransmissionStyle;


void Init_HID(BOOL ignoreTCP);

typedef struct
{
    unsigned long  HIDAddress;  // HID Destination IP address.
    unsigned short HIDPort;     // HID Destination Port number
    unsigned char  HIDConnect;  // HID Connection type.
    unsigned char  resv[4];     // future
}HIDCONN_PARAM;

extern HIDCONN_PARAM *GetHidConnParams(void);
extern INT32 SetHIDAddress(UINT32 ignore, char * cmd);
extern INT32 SetHIDConnect(UINT32 ignore, char * cmd);
extern INT32 SetHIDPort(UINT32 ignore, char * cmd);
extern INT32 HIDSendMousePacket(unsigned char buttons, unsigned char xDelta, unsigned char yDelta, unsigned char zDelta );
extern INT32 HIDSendKeyboardPacket(unsigned char mod, unsigned char *key);
extern BOOL ProcessHIDSerialJoin(const char * msg);
extern void HID_Reset_Mouse_Button_State(void);
UINT8 GetUSBHIDControlSerialJoin(UINT8 **pSerialString);

#ifdef __cplusplus
 }
#endif

#endif